<?php

/**
 * @file
 * Provides a list of countries and languages based on web standards.
 */

/**
 * Get an array of all country code => country name pairs.
 *
 * Get an array of all country code => country name pairs as laid out
 * in ISO 3166-1 alpha-2. Originally from the location project
 * (http://drupal.org/project/location).
 *
 * @return
 *   An array of country code => country name pairs.
 */
function standard_country_list() {
  static $countries;

  if (isset($countries)) {
    return $countries;
  }
  $t = get_t();

  $countries = array(
    'AD' => $t('Andorra'),
    'AE' => $t('United Arab Emirates'),
    'AF' => $t('Afghanistan'),
    'AG' => $t('Antigua and Barbuda'),
    'AI' => $t('Anguilla'),
    'AL' => $t('Albania'),
    'AM' => $t('Armenia'),
    'AN' => $t('Netherlands Antilles'),
    'AO' => $t('Angola'),
    'AQ' => $t('Antarctica'),
    'AR' => $t('Argentina'),
    'AS' => $t('American Samoa'),
    'AT' => $t('Austria'),
    'AU' => $t('Australia'),
    'AW' => $t('Aruba'),
    'AX' => $t('Aland Islands'),
    'AZ' => $t('Azerbaijan'),
    'BA' => $t('Bosnia and Herzegovina'),
    'BB' => $t('Barbados'),
    'BD' => $t('Bangladesh'),
    'BE' => $t('Belgium'),
    'BF' => $t('Burkina Faso'),
    'BG' => $t('Bulgaria'),
    'BH' => $t('Bahrain'),
    'BI' => $t('Burundi'),
    'BJ' => $t('Benin'),
    'BL' => $t('Saint Barthélemy'),
    'BM' => $t('Bermuda'),
    'BN' => $t('Brunei'),
    'BO' => $t('Bolivia'),
    'BQ' => $t('Caribbean Netherlands'),    
    'BR' => $t('Brazil'),
    'BS' => $t('Bahamas'),
    'BT' => $t('Bhutan'),
    'BV' => $t('Bouvet Island'),
    'BW' => $t('Botswana'),
    'BY' => $t('Belarus'),
    'BZ' => $t('Belize'),
    'CA' => $t('Canada'),
    'CC' => $t('Cocos (Keeling) Islands'),
    'CD' => $t('Congo (Kinshasa)'),
    'CF' => $t('Central African Republic'),
    'CG' => $t('Congo (Brazzaville)'),
    'CH' => $t('Switzerland'),
    'CI' => $t('Ivory Coast'),
    'CK' => $t('Cook Islands'),
    'CL' => $t('Chile'),
    'CM' => $t('Cameroon'),
    'CN' => $t('China'),
    'CO' => $t('Colombia'),
    'CR' => $t('Costa Rica'),
    'CU' => $t('Cuba'),
    'CV' => $t('Cape Verde'),
    'CW' => $t('Curaçao'),
    'CX' => $t('Christmas Island'),
    'CY' => $t('Cyprus'),
    'CZ' => $t('Czech Republic'),
    'DE' => $t('Germany'),
    'DJ' => $t('Djibouti'),
    'DK' => $t('Denmark'),
    'DM' => $t('Dominica'),
    'DO' => $t('Dominican Republic'),
    'DZ' => $t('Algeria'),
    'EC' => $t('Ecuador'),
    'EE' => $t('Estonia'),
    'EG' => $t('Egypt'),
    'EH' => $t('Western Sahara'),
    'ER' => $t('Eritrea'),
    'ES' => $t('Spain'),
    'ET' => $t('Ethiopia'),
    'FI' => $t('Finland'),
    'FJ' => $t('Fiji'),
    'FK' => $t('Falkland Islands'),
    'FM' => $t('Micronesia'),
    'FO' => $t('Faroe Islands'),
    'FR' => $t('France'),
    'GA' => $t('Gabon'),
    'GB' => $t('United Kingdom'),
    'GD' => $t('Grenada'),
    'GE' => $t('Georgia'),
    'GF' => $t('French Guiana'),
    'GG' => $t('Guernsey'),
    'GH' => $t('Ghana'),
    'GI' => $t('Gibraltar'),
    'GL' => $t('Greenland'),
    'GM' => $t('Gambia'),
    'GN' => $t('Guinea'),
    'GP' => $t('Guadeloupe'),
    'GQ' => $t('Equatorial Guinea'),
    'GR' => $t('Greece'),
    'GS' => $t('South Georgia and the South Sandwich Islands'),
    'GT' => $t('Guatemala'),
    'GU' => $t('Guam'),
    'GW' => $t('Guinea-Bissau'),
    'GY' => $t('Guyana'),
    'HK' => $t('Hong Kong S.A.R., China'),
    'HM' => $t('Heard Island and McDonald Islands'),
    'HN' => $t('Honduras'),
    'HR' => $t('Croatia'),
    'HT' => $t('Haiti'),
    'HU' => $t('Hungary'),
    'ID' => $t('Indonesia'),
    'IE' => $t('Ireland'),
    'IL' => $t('Israel'),
    'IM' => $t('Isle of Man'),
    'IN' => $t('India'),
    'IO' => $t('British Indian Ocean Territory'),
    'IQ' => $t('Iraq'),
    'IR' => $t('Iran'),
    'IS' => $t('Iceland'),
    'IT' => $t('Italy'),
    'JE' => $t('Jersey'),
    'JM' => $t('Jamaica'),
    'JO' => $t('Jordan'),
    'JP' => $t('Japan'),
    'KE' => $t('Kenya'),
    'KG' => $t('Kyrgyzstan'),
    'KH' => $t('Cambodia'),
    'KI' => $t('Kiribati'),
    'KM' => $t('Comoros'),
    'KN' => $t('Saint Kitts and Nevis'),
    'KP' => $t('North Korea'),
    'KR' => $t('South Korea'),
    'KW' => $t('Kuwait'),
    'KY' => $t('Cayman Islands'),
    'KZ' => $t('Kazakhstan'),
    'LA' => $t('Laos'),
    'LB' => $t('Lebanon'),
    'LC' => $t('Saint Lucia'),
    'LI' => $t('Liechtenstein'),
    'LK' => $t('Sri Lanka'),
    'LR' => $t('Liberia'),
    'LS' => $t('Lesotho'),
    'LT' => $t('Lithuania'),
    'LU' => $t('Luxembourg'),
    'LV' => $t('Latvia'),
    'LY' => $t('Libya'),
    'MA' => $t('Morocco'),
    'MC' => $t('Monaco'),
    'MD' => $t('Moldova'),
    'ME' => $t('Montenegro'),
    'MF' => $t('Saint Martin (French part)'),
    'MG' => $t('Madagascar'),
    'MH' => $t('Marshall Islands'),
    'MK' => $t('Macedonia'),
    'ML' => $t('Mali'),
    'MM' => $t('Myanmar'),
    'MN' => $t('Mongolia'),
    'MO' => $t('Macao S.A.R., China'),
    'MP' => $t('Northern Mariana Islands'),
    'MQ' => $t('Martinique'),
    'MR' => $t('Mauritania'),
    'MS' => $t('Montserrat'),
    'MT' => $t('Malta'),
    'MU' => $t('Mauritius'),
    'MV' => $t('Maldives'),
    'MW' => $t('Malawi'),
    'MX' => $t('Mexico'),
    'MY' => $t('Malaysia'),
    'MZ' => $t('Mozambique'),
    'NA' => $t('Namibia'),
    'NC' => $t('New Caledonia'),
    'NE' => $t('Niger'),
    'NF' => $t('Norfolk Island'),
    'NG' => $t('Nigeria'),
    'NI' => $t('Nicaragua'),
    'NL' => $t('Netherlands'),
    'NO' => $t('Norway'),
    'NP' => $t('Nepal'),
    'NR' => $t('Nauru'),
    'NU' => $t('Niue'),
    'NZ' => $t('New Zealand'),
    'OM' => $t('Oman'),
    'PA' => $t('Panama'),
    'PE' => $t('Peru'),
    'PF' => $t('French Polynesia'),
    'PG' => $t('Papua New Guinea'),
    'PH' => $t('Philippines'),
    'PK' => $t('Pakistan'),
    'PL' => $t('Poland'),
    'PM' => $t('Saint Pierre and Miquelon'),
    'PN' => $t('Pitcairn'),
    'PR' => $t('Puerto Rico'),
    'PS' => $t('Palestinian Territory'),
    'PT' => $t('Portugal'),
    'PW' => $t('Palau'),
    'PY' => $t('Paraguay'),
    'QA' => $t('Qatar'),
    'RE' => $t('Reunion'),
    'RO' => $t('Romania'),
    'RS' => $t('Serbia'),
    'RU' => $t('Russia'),
    'RW' => $t('Rwanda'),
    'SA' => $t('Saudi Arabia'),
    'SB' => $t('Solomon Islands'),
    'SC' => $t('Seychelles'),
    'SD' => $t('Sudan'),
    'SE' => $t('Sweden'),
    'SG' => $t('Singapore'),
    'SH' => $t('Saint Helena'),
    'SI' => $t('Slovenia'),
    'SJ' => $t('Svalbard and Jan Mayen'),
    'SK' => $t('Slovakia'),
    'SL' => $t('Sierra Leone'),
    'SM' => $t('San Marino'),
    'SN' => $t('Senegal'),
    'SO' => $t('Somalia'),
    'SR' => $t('Suriname'),
    'SS' => $t('South Sudan'),    
    'ST' => $t('Sao Tome and Principe'),
    'SV' => $t('El Salvador'),
    'SX' => $t('Sint Maarten'),    
    'SY' => $t('Syria'),
    'SZ' => $t('Swaziland'),
    'TC' => $t('Turks and Caicos Islands'),
    'TD' => $t('Chad'),
    'TF' => $t('French Southern Territories'),
    'TG' => $t('Togo'),
    'TH' => $t('Thailand'),
    'TJ' => $t('Tajikistan'),
    'TK' => $t('Tokelau'),
    'TL' => $t('Timor-Leste'),
    'TM' => $t('Turkmenistan'),
    'TN' => $t('Tunisia'),
    'TO' => $t('Tonga'),
    'TR' => $t('Turkey'),
    'TT' => $t('Trinidad and Tobago'),
    'TV' => $t('Tuvalu'),
    'TW' => $t('Taiwan'),
    'TZ' => $t('Tanzania'),
    'UA' => $t('Ukraine'),
    'UG' => $t('Uganda'),
    'UM' => $t('United States Minor Outlying Islands'),
    'US' => $t('United States'),
    'UY' => $t('Uruguay'),
    'UZ' => $t('Uzbekistan'),
    'VA' => $t('Vatican'),
    'VC' => $t('Saint Vincent and the Grenadines'),
    'VE' => $t('Venezuela'),
    'VG' => $t('British Virgin Islands'),
    'VI' => $t('U.S. Virgin Islands'),
    'VN' => $t('Vietnam'),
    'VU' => $t('Vanuatu'),
    'WF' => $t('Wallis and Futuna'),
    'WS' => $t('Samoa'),
    'YE' => $t('Yemen'),
    'YT' => $t('Mayotte'),
    'ZA' => $t('South Africa'),
    'ZM' => $t('Zambia'),
    'ZW' => $t('Zimbabwe'),
  );

  // Sort the list.
  natcasesort($countries);

  return $countries;
}

/**
 * Some common languages with their English and native names.
 *
 * Language codes are defined by the W3C language tags document for
 * interoperability. Language codes typically have a language and optionally,
 * a script or regional variant name. See
 * http://www.w3.org/International/articles/language-tags/ for more information.
 *
 * This list is based on languages available from localize.drupal.org. See
 * http://localize.drupal.org/issues for information on how to add languages
 * there.
 *
 * The "Left-to-right marker" comments and the enclosed UTF-8 markers are to
 * make otherwise strange looking PHP syntax natural (to not be displayed in
 * right to left). See http://drupal.org/node/128866#comment-528929.
 *
 * @return
 *   An array of language code to language name information.
 *   Language name information itself is an array of English and native names.
 */
function standard_language_list() {
  return array(
    'af' => array('Afrikaans', 'Afrikaans'),
    'am' => array('Amharic', 'አማርኛ'),
    'ar' => array('Arabic', /* Left-to-right marker "‭" */ 'العربية', LANGUAGE_RTL),
    'ast' => array('Asturian', 'Asturianu'),
    'az' => array('Azerbaijani', 'Azərbaycanca'),
    'be' => array('Belarusian', 'Беларуская'),
    'bg' => array('Bulgarian', 'Български'),
    'bn' => array('Bengali', 'বাংলা'),
    'bo' => array('Tibetan', 'བོད་སྐད་'),
    'bs' => array('Bosnian', 'Bosanski'),
    'ca' => array('Catalan', 'Català'),
    'cs' => array('Czech', 'Čeština'),
    'cy' => array('Welsh', 'Cymraeg'),
    'da' => array('Danish', 'Dansk'),
    'de' => array('German', 'Deutsch'),
    'dz' => array('Dzongkha', 'རྫོང་ཁ'),
    'el' => array('Greek', 'Ελληνικά'),
    'en' => array('English', 'English'),
    'en-gb' => array('English, British', 'English, British'),
    'eo' => array('Esperanto', 'Esperanto'),
    'es' => array('Spanish', 'Español'),
    'et' => array('Estonian', 'Eesti'),
    'eu' => array('Basque', 'Euskera'),
    'fa' => array('Persian, Farsi', /* Left-to-right marker "‭" */ 'فارسی', LANGUAGE_RTL),
    'fi' => array('Finnish', 'Suomi'),
    'fil' => array('Filipino', 'Filipino'),
    'fo' => array('Faeroese', 'Føroyskt'),
    'fr' => array('French', 'Français'),
    'fy' => array('Frisian', 'Frysk'),
    'ga' => array('Irish', 'Gaeilge'),
    'gd' => array('Scots Gaelic', 'Gàidhlig'),
    'gl' => array('Galician', 'Galego'),
    'gsw-berne' => array('Swiss German', 'Schwyzerdütsch'),
    'gu' => array('Gujarati', 'ગુજરાતી'),
    'he' => array('Hebrew', /* Left-to-right marker "‭" */ 'עברית', LANGUAGE_RTL),
    'hi' => array('Hindi', 'हिन्दी'),
    'hr' => array('Croatian', 'Hrvatski'),
    'ht' => array('Haitian Creole', 'Kreyòl ayisyen'),
    'hu' => array('Hungarian', 'Magyar'),
    'hy' => array('Armenian', 'Հայերեն'),
    'id' => array('Indonesian', 'Bahasa Indonesia'),
    'is' => array('Icelandic', 'Íslenska'),
    'it' => array('Italian', 'Italiano'),
    'ja' => array('Japanese', '日本語'),
    'jv' => array('Javanese', 'Basa Java'),
    'ka' => array('Georgian', 'ქართული ენა'),
    'kk' => array('Kazakh', 'Қазақ'),
    'km' => array('Cambodian'),
    'kn' => array('Kannada', 'ಕನ್ನಡ'),
    'ko' => array('Korean', '한국어'),
    'ku' => array('Kurdish', 'Kurdî'),
    'ky' => array('Kyrgyz', 'Кыргызча'),
    'lo' => array('Lao', 'ພາສາລາວ'),
    'lt' => array('Lithuanian', 'Lietuvių'),
    'lv' => array('Latvian', 'Latviešu'),
    'mfe' => array('Mauritian Creole', 'Kreol Morisyen'),
    'mg' => array('Malagasy', 'Malagasy'),
    'mi' => array('Maori', 'Māori'),
    'mk' => array('Macedonian', 'Македонски'),
    'ml' => array('Malayalam', 'മലയാളം'),
    'mn' => array('Mongolian', 'монгол'),
    'mr' => array('Marathi', 'मराठी'),
    'ms' => array('Malay', 'Bahasa Melayu'),
    'mt' => array('Maltese', 'Malti'),
    'my' => array('Burmese', 'ဗမာစကား'),
    'ne' => array('Nepali', 'नेपाली'),
    'nl' => array('Dutch', 'Nederlands'),
    'nb' => array('Norwegian Bokmål', 'Bokmål'),
    'nn' => array('Norwegian Nynorsk', 'Nynorsk'),
    'oc' => array('Occitan', 'Occitan'),
    'or' => array('Oriya', 'ଓଡ଼ିଆ'),
    'os' => array('Ossetian'),
    'pa' => array('Punjabi', 'ਪੰਜਾਬੀ'),
    'pl' => array('Polish', 'Polski'),
    'prs' => array('Afghanistan Persian'),
    'ps' => array('Pashto', /* Left-to-right marker "‭" */ 'پښتو', LANGUAGE_RTL),
    'pt' => array('Portuguese, International', 'Português, Internacional'),
    'pt-pt' => array('Portuguese, Portugal', 'Português, Portugal'),
    'pt-br' => array('Portuguese, Brazil', 'Português, Brasil'),
    'ro' => array('Romanian', 'Română'),
    'ru' => array('Russian', 'Русский'),
    'sco' => array('Scots', 'Scots'),
    'se' => array('Northern Sami', 'Sámi'),
    'si' => array('Sinhala', 'සිංහල'),
    'sk' => array('Slovak', 'Slovenčina'),
    'sl' => array('Slovenian', 'Slovenščina'),
    'sq' => array('Albanian', 'Shqip'),
    'sr' => array('Serbian', 'Српски'),
    'sv' => array('Swedish', 'Svenska'),
    'sw' => array('Swahili', 'Kiswahili'),
    'ta' => array('Tamil', 'தமிழ்'),
    'ta-lk' => array('Tamil, Sri Lanka', 'தமிழ், இலங்கை'),
    'te' => array('Telugu', 'తెలుగు'),
    'th' => array('Thai', 'ภาษาไทย'),
    'ti' => array('Tigrinya', 'ትግርኛ'),
    'tr' => array('Turkish', 'Türkçe'),
    'tyv' => array('Tuvan'),
    'ug' => array('Uyghur', 'Уйғур'),
    'uk' => array('Ukrainian', 'Українська'),
    'ur' => array('Urdu', /* Left-to-right marker "‭" */ 'اردو', LANGUAGE_RTL),
    'vi' => array('Vietnamese', 'Tiếng Việt'),
    'xx-lolspeak' => array('Lolspeak', 'Lolspeak'),
    'zh-hans' => array('Chinese, Simplified', '简体中文'),
    'zh-hant' => array('Chinese, Traditional', '繁體中文'),
  );
}

/**
 * Get an array of all timezones and their matching country code.
 *
 * @return
 *   An array of timezone => country code pairs.
 */
function standard_timezone_country_list() {
  static $timezone_countries;

  if (isset($timezone_countries)) {
    return $timezone_countries;
  }

  $timezone_countries = array(
    'Africa/Abidjan' => 'CI',
    'Africa/Accra' => 'GH',
    'Africa/Addis_Ababa' => 'ET',
    'Africa/Algiers' => 'DZ',
    'Africa/Asmara' => 'ER',
    'Africa/Bamako' => 'ML',
    'Africa/Bangui' => 'CF',
    'Africa/Banjul' => 'GM',
    'Africa/Bissau' => 'GW',
    'Africa/Blantyre' => 'MW',
    'Africa/Brazzaville' => 'CG',
    'Africa/Bujumbura' => 'BI',
    'Africa/Cairo' => 'EG',
    'Africa/Casablanca' => 'MA',
    'Africa/Ceuta' => 'ES',
    'Africa/Conakry' => 'GN',
    'Africa/Dakar' => 'SN',
    'Africa/Dar_es_Salaam' => 'TZ',
    'Africa/Djibouti' => 'DJ',
    'Africa/Douala' => 'CM',
    'Africa/El_Aaiun' => 'EH',
    'Africa/Freetown' => 'SL',
    'Africa/Gaborone' => 'BW',
    'Africa/Harare' => 'ZW',
    'Africa/Johannesburg' => 'ZA',
    'Africa/Juba' => 'SS',
    'Africa/Kampala' => 'UG',
    'Africa/Khartoum' => 'SD',
    'Africa/Kigali' => 'RW',
    'Africa/Kinshasa' => 'CD',
    'Africa/Lagos' => 'NG',
    'Africa/Libreville' => 'GA',
    'Africa/Lome' => 'TG',
    'Africa/Luanda' => 'AO',
    'Africa/Lubumbashi' => 'CD',
    'Africa/Lusaka' => 'ZM',
    'Africa/Malabo' => 'GQ',
    'Africa/Maputo' => 'MZ',
    'Africa/Maseru' => 'LS',
    'Africa/Mbabane' => 'SZ',
    'Africa/Mogadishu' => 'SO',
    'Africa/Monrovia' => 'LR',
    'Africa/Nairobi' => 'KE',
    'Africa/Ndjamena' => 'TD',
    'Africa/Niamey' => 'NE',
    'Africa/Nouakchott' => 'MR',
    'Africa/Ouagadougou' => 'BF',
    'Africa/Porto-Novo' => 'BJ',
    'Africa/Sao_Tome' => 'ST',
    'Africa/Tripoli' => 'LY',
    'Africa/Tunis' => 'TN',
    'Africa/Windhoek' => 'NA',
    'America/Adak' => 'US',
    'America/Anchorage' => 'US',
    'America/Anguilla' => 'AI',
    'America/Antigua' => 'AG',
    'America/Araguaina' => 'BR',
    'America/Argentina/Buenos_Aires' => 'AR',
    'America/Argentina/Catamarca' => 'AR',
    'America/Argentina/Cordoba' => 'AR',
    'America/Argentina/Jujuy' => 'AR',
    'America/Argentina/La_Rioja' => 'AR',
    'America/Argentina/Mendoza' => 'AR',
    'America/Argentina/Rio_Gallegos' => 'AR',
    'America/Argentina/Salta' => 'AR',
    'America/Argentina/San_Juan' => 'AR',
    'America/Argentina/San_Luis' => 'AR',
    'America/Argentina/Tucuman' => 'AR',
    'America/Argentina/Ushuaia' => 'AR',
    'America/Aruba' => 'AW',
    'America/Asuncion' => 'PY',
    'America/Atikokan' => 'CA',
    'America/Bahia' => 'BR',
    'America/Bahia_Banderas' => 'MX',
    'America/Barbados' => 'BB',
    'America/Belem' => 'BR',
    'America/Belize' => 'BZ',
    'America/Blanc-Sablon' => 'CA',
    'America/Boa_Vista' => 'BR',
    'America/Bogota' => 'CO',
    'America/Boise' => 'US',
    'America/Cambridge_Bay' => 'CA',
    'America/Campo_Grande' => 'BR',
    'America/Cancun' => 'MX',
    'America/Caracas' => 'VE',
    'America/Cayenne' => 'GF',
    'America/Cayman' => 'KY',
    'America/Chicago' => 'US',
    'America/Chihuahua' => 'MX',
    'America/Costa_Rica' => 'CR',
    'America/Creston' => 'CA',
    'America/Cuiaba' => 'BR',
    'America/Curacao' => 'CW',
    'America/Danmarkshavn' => 'GL',
    'America/Dawson' => 'CA',
    'America/Dawson_Creek' => 'CA',
    'America/Denver' => 'US',
    'America/Detroit' => 'US',
    'America/Dominica' => 'DM',
    'America/Edmonton' => 'CA',
    'America/Eirunepe' => 'BR',
    'America/El_Salvador' => 'SV',
    'America/Fortaleza' => 'BR',
    'America/Glace_Bay' => 'CA',
    'America/Godthab' => 'GL',
    'America/Goose_Bay' => 'CA',
    'America/Grand_Turk' => 'TC',
    'America/Grenada' => 'GD',
    'America/Guadeloupe' => 'GP',
    'America/Guatemala' => 'GT',
    'America/Guayaquil' => 'EC',
    'America/Guyana' => 'GY',
    'America/Halifax' => 'CA',
    'America/Havana' => 'CU',
    'America/Hermosillo' => 'MX',
    'America/Indiana/Indianapolis' => 'US',
    'America/Indiana/Knox' => 'US',
    'America/Indiana/Marengo' => 'US',
    'America/Indiana/Petersburg' => 'US',
    'America/Indiana/Tell_City' => 'US',
    'America/Indiana/Vevay' => 'US',
    'America/Indiana/Vincennes' => 'US',
    'America/Indiana/Winamac' => 'US',
    'America/Inuvik' => 'CA',
    'America/Iqaluit' => 'CA',
    'America/Jamaica' => 'JM',
    'America/Juneau' => 'US',
    'America/Kentucky/Louisville' => 'US',
    'America/Kentucky/Monticello' => 'US',
    'America/Kralendijk' => 'BQ',
    'America/La_Paz' => 'BO',
    'America/Lima' => 'PE',
    'America/Los_Angeles' => 'US',
    'America/Lower_Princes' => 'SX',
    'America/Maceio' => 'BR',
    'America/Managua' => 'NI',
    'America/Manaus' => 'BR',
    'America/Marigot' => 'MF',
    'America/Martinique' => 'MQ',
    'America/Matamoros' => 'MX',
    'America/Mazatlan' => 'MX',
    'America/Menominee' => 'US',
    'America/Merida' => 'MX',
    'America/Metlakatla' => 'US',
    'America/Mexico_City' => 'MX',
    'America/Miquelon' => 'PM',
    'America/Moncton' => 'CA',
    'America/Monterrey' => 'MX',
    'America/Montevideo' => 'UY',
    'America/Montserrat' => 'MS',
    'America/Nassau' => 'BS',
    'America/New_York' => 'US',
    'America/Nipigon' => 'CA',
    'America/Nome' => 'US',
    'America/Noronha' => 'BR',
    'America/North_Dakota/Beulah' => 'US',
    'America/North_Dakota/Center' => 'US',
    'America/North_Dakota/New_Salem' => 'US',
    'America/Ojinaga' => 'MX',
    'America/Panama' => 'PA',
    'America/Pangnirtung' => 'CA',
    'America/Paramaribo' => 'SR',
    'America/Phoenix' => 'US',
    'America/Port_of_Spain' => 'TT',
    'America/Port-au-Prince' => 'HT',
    'America/Porto_Velho' => 'BR',
    'America/Puerto_Rico' => 'PR',
    'America/Rainy_River' => 'CA',
    'America/Rankin_Inlet' => 'CA',
    'America/Recife' => 'BR',
    'America/Regina' => 'CA',
    'America/Resolute' => 'CA',
    'America/Rio_Branco' => 'BR',
    'America/Santa_Isabel' => 'MX',
    'America/Santarem' => 'BR',
    'America/Santiago' => 'CL',
    'America/Santo_Domingo' => 'DO',
    'America/Sao_Paulo' => 'BR',
    'America/Scoresbysund' => 'GL',
    'America/Sitka' => 'US',
    'America/St_Barthelemy' => 'BL',
    'America/St_Johns' => 'CA',
    'America/St_Kitts' => 'KN',
    'America/St_Lucia' => 'LC',
    'America/St_Thomas' => 'VI',
    'America/St_Vincent' => 'VC',
    'America/Swift_Current' => 'CA',
    'America/Tegucigalpa' => 'HN',
    'America/Thule' => 'GL',
    'America/Thunder_Bay' => 'CA',
    'America/Tijuana' => 'MX',
    'America/Toronto' => 'CA',
    'America/Tortola' => 'VG',
    'America/Vancouver' => 'CA',
    'America/Whitehorse' => 'CA',
    'America/Winnipeg' => 'CA',
    'America/Yakutat' => 'US',
    'America/Yellowknife' => 'CA',
    'Antarctica/Casey' => 'AQ',
    'Antarctica/Davis' => 'AQ',
    'Antarctica/DumontDUrville' => 'AQ',
    'Antarctica/Macquarie' => 'AU',
    'Antarctica/Mawson' => 'AQ',
    'Antarctica/McMurdo' => 'AQ',
    'Antarctica/Palmer' => 'AQ',
    'Antarctica/Rothera' => 'AQ',
    'Antarctica/Syowa' => 'AQ',
    'Antarctica/Troll' => 'AQ',
    'Antarctica/Vostok' => 'AQ',
    'Arctic/Longyearbyen' => 'SJ',
    'Asia/Aden' => 'YE',
    'Asia/Almaty' => 'KZ',
    'Asia/Amman' => 'JO',
    'Asia/Anadyr' => 'RU',
    'Asia/Aqtau' => 'KZ',
    'Asia/Aqtobe' => 'KZ',
    'Asia/Ashgabat' => 'TM',
    'Asia/Baghdad' => 'IQ',
    'Asia/Bahrain' => 'BH',
    'Asia/Baku' => 'AZ',
    'Asia/Bangkok' => 'TH',
    'Asia/Beirut' => 'LB',
    'Asia/Bishkek' => 'KG',
    'Asia/Brunei' => 'BN',
    'Asia/Choibalsan' => 'MN',
    'Asia/Chongqing' => 'CN',
    'Asia/Colombo' => 'LK',
    'Asia/Damascus' => 'SY',
    'Asia/Dhaka' => 'BD',
    'Asia/Dili' => 'TL',
    'Asia/Dubai' => 'AE',
    'Asia/Dushanbe' => 'TJ',
    'Asia/Gaza' => 'PS',
    'Asia/Harbin' => 'CN',
    'Asia/Hebron' => 'PS',
    'Asia/Ho_Chi_Minh' => 'VN',
    'Asia/Hong_Kong' => 'HK',
    'Asia/Hovd' => 'MN',
    'Asia/Irkutsk' => 'RU',
    'Asia/Jakarta' => 'ID',
    'Asia/Jayapura' => 'ID',
    'Asia/Jerusalem' => 'IL',
    'Asia/Kabul' => 'AF',
    'Asia/Kamchatka' => 'RU',
    'Asia/Karachi' => 'PK',
    'Asia/Kashgar' => 'CN',
    'Asia/Kathmandu' => 'NP',
    'Asia/Khandyga' => 'RU',
    'Asia/Kolkata' => 'IN',
    'Asia/Krasnoyarsk' => 'RU',
    'Asia/Kuala_Lumpur' => 'MY',
    'Asia/Kuching' => 'MY',
    'Asia/Kuwait' => 'KW',
    'Asia/Macau' => 'MO',
    'Asia/Magadan' => 'RU',
    'Asia/Makassar' => 'ID',
    'Asia/Manila' => 'PH',
    'Asia/Muscat' => 'OM',
    'Asia/Nicosia' => 'CY',
    'Asia/Novokuznetsk' => 'RU',
    'Asia/Novosibirsk' => 'RU',
    'Asia/Omsk' => 'RU',
    'Asia/Oral' => 'KZ',
    'Asia/Phnom_Penh' => 'KH',
    'Asia/Pontianak' => 'ID',
    'Asia/Pyongyang' => 'KP',
    'Asia/Qatar' => 'QA',
    'Asia/Qyzylorda' => 'KZ',
    'Asia/Rangoon' => 'MM',
    'Asia/Riyadh' => 'SA',
    'Asia/Sakhalin' => 'RU',
    'Asia/Samarkand' => 'UZ',
    'Asia/Seoul' => 'KR',
    'Asia/Shanghai' => 'CN',
    'Asia/Singapore' => 'SG',
    'Asia/Taipei' => 'TW',
    'Asia/Tashkent' => 'UZ',
    'Asia/Tbilisi' => 'GE',
    'Asia/Tehran' => 'IR',
    'Asia/Thimphu' => 'BT',
    'Asia/Tokyo' => 'JP',
    'Asia/Ulaanbaatar' => 'MN',
    'Asia/Urumqi' => 'CN',
    'Asia/Ust-Nera' => 'RU',
    'Asia/Vientiane' => 'LA',
    'Asia/Vladivostok' => 'RU',
    'Asia/Yakutsk' => 'RU',
    'Asia/Yekaterinburg' => 'RU',
    'Asia/Yerevan' => 'AM',
    'Atlantic/Azores' => 'PT',
    'Atlantic/Bermuda' => 'BM',
    'Atlantic/Canary' => 'ES',
    'Atlantic/Cape_Verde' => 'CV',
    'Atlantic/Faroe' => 'FO',
    'Atlantic/Madeira' => 'PT',
    'Atlantic/Reykjavik' => 'IS',
    'Atlantic/South_Georgia' => 'GS',
    'Atlantic/St_Helena' => 'SH',
    'Atlantic/Stanley' => 'FK',
    'Australia/Adelaide' => 'AU',
    'Australia/Brisbane' => 'AU',
    'Australia/Broken_Hill' => 'AU',
    'Australia/Currie' => 'AU',
    'Australia/Darwin' => 'AU',
    'Australia/Eucla' => 'AU',
    'Australia/Hobart' => 'AU',
    'Australia/Lindeman' => 'AU',
    'Australia/Lord_Howe' => 'AU',
    'Australia/Melbourne' => 'AU',
    'Australia/Perth' => 'AU',
    'Australia/Sydney' => 'AU',
    'Europe/Amsterdam' => 'NL',
    'Europe/Andorra' => 'AD',
    'Europe/Athens' => 'GR',
    'Europe/Belgrade' => 'RS',
    'Europe/Berlin' => 'DE',
    'Europe/Bratislava' => 'SK',
    'Europe/Brussels' => 'BE',
    'Europe/Bucharest' => 'RO',
    'Europe/Budapest' => 'HU',
    'Europe/Busingen' => 'DE',
    'Europe/Chisinau' => 'MD',
    'Europe/Copenhagen' => 'DK',
    'Europe/Dublin' => 'IE',
    'Europe/Gibraltar' => 'GI',
    'Europe/Guernsey' => 'GG',
    'Europe/Helsinki' => 'FI',
    'Europe/Isle_of_Man' => 'IM',
    'Europe/Istanbul' => 'TR',
    'Europe/Jersey' => 'JE',
    'Europe/Kaliningrad' => 'RU',
    'Europe/Kiev' => 'UA',
    'Europe/Lisbon' => 'PT',
    'Europe/Ljubljana' => 'SI',
    'Europe/London' => 'GB',
    'Europe/Luxembourg' => 'LU',
    'Europe/Madrid' => 'ES',
    'Europe/Malta' => 'MT',
    'Europe/Mariehamn' => 'AX',
    'Europe/Minsk' => 'BY',
    'Europe/Monaco' => 'MC',
    'Europe/Moscow' => 'RU',
    'Europe/Oslo' => 'NO',
    'Europe/Paris' => 'FR',
    'Europe/Podgorica' => 'ME',
    'Europe/Prague' => 'CZ',
    'Europe/Riga' => 'LV',
    'Europe/Rome' => 'IT',
    'Europe/Samara' => 'RU',
    'Europe/San_Marino' => 'SM',
    'Europe/Sarajevo' => 'BA',
    'Europe/Simferopol' => 'UA',
    'Europe/Skopje' => 'MK',
    'Europe/Sofia' => 'BG',
    'Europe/Stockholm' => 'SE',
    'Europe/Tallinn' => 'EE',
    'Europe/Tirane' => 'AL',
    'Europe/Uzhgorod' => 'UA',
    'Europe/Vaduz' => 'LI',
    'Europe/Vatican' => 'VA',
    'Europe/Vienna' => 'AT',
    'Europe/Vilnius' => 'LT',
    'Europe/Volgograd' => 'RU',
    'Europe/Warsaw' => 'PL',
    'Europe/Zagreb' => 'HR',
    'Europe/Zaporozhye' => 'UA',
    'Europe/Zurich' => 'CH',
    'Indian/Antananarivo' => 'MG',
    'Indian/Chagos' => 'IO',
    'Indian/Christmas' => 'CX',
    'Indian/Cocos' => 'CC',
    'Indian/Comoro' => 'KM',
    'Indian/Kerguelen' => 'TF',
    'Indian/Mahe' => 'SC',
    'Indian/Maldives' => 'MV',
    'Indian/Mauritius' => 'MU',
    'Indian/Mayotte' => 'YT',
    'Indian/Reunion' => 'RE',
    'Pacific/Apia' => 'WS',
    'Pacific/Auckland' => 'NZ',
    'Pacific/Chatham' => 'NZ',
    'Pacific/Chuuk' => 'FM',
    'Pacific/Easter' => 'CL',
    'Pacific/Efate' => 'VU',
    'Pacific/Enderbury' => 'KI',
    'Pacific/Fakaofo' => 'TK',
    'Pacific/Fiji' => 'FJ',
    'Pacific/Funafuti' => 'TV',
    'Pacific/Galapagos' => 'EC',
    'Pacific/Gambier' => 'PF',
    'Pacific/Guadalcanal' => 'SB',
    'Pacific/Guam' => 'GU',
    'Pacific/Honolulu' => 'US',
    'Pacific/Johnston' => 'US',
    'Pacific/Kiritimati' => 'KI',
    'Pacific/Kosrae' => 'FM',
    'Pacific/Kwajalein' => 'MH',
    'Pacific/Majuro' => 'MH',
    'Pacific/Marquesas' => 'PF',
    'Pacific/Midway' => 'US',
    'Pacific/Nauru' => 'NR',
    'Pacific/Niue' => 'NU',
    'Pacific/Norfolk' => 'NF',
    'Pacific/Noumea' => 'NC',
    'Pacific/Pago_Pago' => 'AS',
    'Pacific/Palau' => 'PW',
    'Pacific/Pitcairn' => 'PN',
    'Pacific/Pohnpei' => 'FM',
    'Pacific/Port_Moresby' => 'PG',
    'Pacific/Rarotonga' => 'CK',
    'Pacific/Saipan' => 'MP',
    'Pacific/Tahiti' => 'PF',
    'Pacific/Tarawa' => 'KI',
    'Pacific/Tongatapu' => 'TO',
    'Pacific/Wake' => 'US',
    'Pacific/Wallis' => 'WF',
  );

  return $timezone_countries;
}
