<?php

/**
 * Lists all the classes used by Backdrop core.
 */
function backdrop_class_list() {

  $path = BACKDROP_ROOT . '/core/includes/';

  // Classes in /core/includes.
  $classes = array(
    'AnonymousUser' => $path . 'anonymous.inc',
    'ArchiverInterface' => $path . 'archiver.inc',
    'BatchQueue' => $path . 'batch.queue.inc',
    'BatchMemoryQueue' => $path . 'batch.queue.inc',
    'BackdropCacheArray' => $path . 'bootstrap.inc',
    'SchemaCache' => $path . 'boostrap.inc',
    'BackdropFakeCache' => $path . 'cache-install.inc',
    'BackdropNullCache' => $path . 'cache.inc',
    'BackdropDatabaseCache' => $path . 'cache.inc',
    'BackdropCacheInterface' => $path . 'cache.inc',
    'BackdropDateTime' => $path . 'date.class.inc',
    'Color' => $path . 'color.inc',
    'Diff' => $path . 'diff.inc',
    'DiffOp' => $path . 'diff.inc',
    'DiffOpCopy' => $path . 'diff.inc',
    'DiffOpDelete' => $path . 'diff.inc',
    'DiffOpAdd' => $path . 'diff.inc',
    'DiffOpChange' => $path . 'diff.inc',
    'DiffOpEngine' => $path . 'diff.inc',
    'MappedDiff' => $path . 'diff.inc',
    'HWLDFWordAccumulator' => $path . 'diff.inc',
    'WordLevelDiff' => $path . 'diff.inc',
    'DiffFormatter' => $path . 'diff.inc',
    'BackdropDiffFormatter' => $path . 'diff.inc',
    'BackdropHTTPSystemInterface' => $path . 'http_system.inc',
    'DatabaseTasks' => $path . 'install.inc',
    'DatabaseTaskException' => $path . 'install.inc',
    'MailSystemInterface' => $path . 'mail.inc',
    'PagerDefault' => $path . 'pager.class.inc',
    'BackdropLocalStreamWrapper' => $path . 'stream_wrappers.inc',
    'BackdropPublicStreamWrapper' => $path . 'stream_wrappers.inc',
    'BackdropPrivateStreamWrapper' => $path . 'stream_wrappers.inc',
    'BackdropTemporaryStreamWrapper' => $path . 'stream_wrappers.inc',
    'StreamWrapperInterface' => $path . 'stream_wrappers.inc',
    'BackdropStreamWrapperInterface' => $path . 'stream_wrappers.inc',
    'TableSort' => $path . 'tablesort.class.inc',
    'ThemeRegistry' => $path . 'theme.inc',
    'BackdropUpdateException' => $path . 'update.inc',
    'BackdropUpdaterInterface' => $path . 'updater.inc',
    'Updater' => $path . 'updater.inc',
    'UpdaterException' => $path . 'updater.inc',
    'UpdaterFileTransferException' => $path . 'updater.inc',
    'UserInterface' => $path . 'userinterface.inc',
    'Uuid' => $path . 'uuid.inc',
    'UuidPecl' => $path . 'uuid.inc',
    'UuidCom' => $path . 'uuid.inc',
    'UuidPhp' => $path . 'uuid.inc',
    'UuidInterface' => $path . 'uuid.inc',

    'DatabaseCharsetConverter' => $path . 'database/charset_converter.inc',
    'DatabaseConnection' => $path . 'database/database.inc',
    'Database' => $path . 'database/database.inc',
    'DatabaseTransactionNoActiveException' => $path . 'database/database.inc',
    'DatabaseTransactionNameNonUniqueException' => $path . 'database/database.inc',
    'DatabaseTransactionCommitFailedException' => $path . 'database/database.inc',
    'DatabaseTransactionCommitNotAllowedException' => $path . 'database/database.inc',
    'DatabaseTransactionOutOfOrderException' => $path . 'database/database.inc',
    'InvalidMergeQueryException' => $path . 'database/database.inc',
    'FieldOverlapException' => $path . 'database/database.inc',
    'NoFieldsException' => $path . 'database/database.inc',
    'DatabaseConnectionNotDefinedException' => $path . 'database/database.inc',
    'DatabaseDriverNotSpecifiedException' => $path . 'database/database.inc',
    'DatabaseTransaction' => $path . 'database/database.inc',
    'DatabaseStatementBase' => $path . 'database/database.inc',
    'DatabaseStatementEmpty' => $path . 'database/database.inc',
    'DatabaseStatementInterface' => $path . 'database/database.inc',
    'DatabaseLog' => $path . 'database/log.inc',
    'DatabaseStatementPrefetch' => $path . 'database/prefetch.inc',
    'Query' => $path . 'database/query.inc',
    'InsertQuery' => $path . 'database/query.inc',
    'DeleteQuery' => $path . 'database/query.inc',
    'TruncateQuery' => $path . 'database/query.inc',
    'UpdateQuery' => $path . 'database/query.inc',
    'MergeQuery' => $path . 'database/query.inc',
    'DatabaseCondition' => $path . 'database/query.inc',
    'QueryConditionInterface' => $path . 'database/query.inc',
    'QueryAlterableInterface' => $path . 'database/query.inc',
    'QueryPlaceholderInterface' => $path . 'database/query.inc',
    'DatabaseSchema' => $path . 'database/schema.inc',
    'DatabaseSchemaObjectExistsException' => $path . 'database/schema.inc',
    'DatabaseSchemaObjectDoesNotExistException' => $path . 'database/schema.inc',
    'SelectQueryExtender' => $path . 'database/select.inc',
    'SelectQuery' => $path . 'database/select.inc',
    'QueryExtendableInterface' => $path . 'database/select.inc',
    'SelectQueryInterface' => $path . 'database/select.inc',

    'DatabaseConnection_mysql' => $path . 'database/mysql/database.inc',
    'DatabaseTasks_mysql' => $path . 'database/mysql/install.inc',
    'InsertQuery_mysql' => $path . 'database/mysql/query.inc',
    'TruncateQuery_mysql' => $path . 'database/mysql/query.inc',
    'DatabaseSchema_mysql' => $path . 'database/mysql/schema.inc',

    'FileTransfer' => $path . 'filetransfer/filetransfer.inc',
    'FileTransferException' => $path . 'filetransfer/filetransfer.inc',
    'SkipDotsRecursiveDirectoryIterator' => $path . 'filetransfer/filetransfer.inc',
    'FileTransferChmodInterface' => $path . 'filetransfer/filetransfer.inc',
    'FileTransferFTP' => $path . 'filetransfer/ftp.inc',
    'FileTransferFTPExtension' => $path . 'filetransfer/ftp.inc',
    'FileTransferLocal' => $path . 'filetransfer/local.inc',
    'FileTransferSSH' => $path . 'filetransfer/ssh.inc',
  );

  // Add in Drupal 7 class name wrappers if compatibility is enabled.
  if (!empty($GLOBALS['settings']['backdrop_drupal_compatibility'])) {
    $classes += array(
      'DrupalQueue' => $path . 'drupal.classes.inc',
      'DrupalQueueInterface' => $path . 'drupal.classes.inc',
      'DrupalReliableQueueInterface' => $path . 'drupal.classes.inc',
      'DrupalCacheArray' => $path . 'drupal.classes.inc',
      'DrupalUpdateException' => $path . 'drupal.classes.inc',
      'DrupalFakeCache' => $path . 'drupal.classes.inc',
      'DrupalDatabaseCache' => $path . 'drupal.classes.inc',
      'DrupalNullCache' => $path . 'drupal.classes.inc',
      'DrupalLocalStreamWrapper' => $path . 'drupal.classes.inc',
      'DrupalPublicStreamWrapper' => $path . 'drupal.classes.inc',
      'DrupalPrivateStreamWrapper' => $path . 'drupal.classes.inc',
      'DrupalTemporaryStreamWrapper' => $path . 'drupal.classes.inc',
      'DrupalStreamWrapperInterface' => $path . 'drupal.classes.inc',
      'DrupalUpdaterInterface' => $path . 'drupal.classes.inc',
      'DrupalTestCase' => $path . 'drupal.classes.inc',
      'DrupalUnitTestCase' => $path . 'drupal.classes.inc',
      'DrupalWebTestCase' => $path . 'drupal.classes.inc',
      'DrupalDefaultEntityController' => $path . 'drupal.classes.inc',
      'DrupalEntityControllerInterface' => $path . 'drupal.classes.inc',
    );
  }

  return $classes;
}
